: Profile, The 1D Scientific Spreadsheet               IBM-PC Version
: by Gertjan L. Ouwerling, Electrical Materials Lab, Delft University
: -------------------------------------------------------------------
: Execute this tutorial by typing:  prof tutorial.pro <enter>
:
: NOTE: some steps may be slow without a co-processor!
:       Graphical pictures are terminated by giving <enter>
: -------------------------------------------------------------------
:
: In this tutorial the following subjects are treated:
:
: 1. Profile on the IBM-PC (and its video adaptor card)
: 2. Profile data structures (variables and data types)
: 3. Internal generation of data and making graphs
: 4. Reading and writing data from and to file
: 5. Escaping to the operating system (on the PC MS-DOS)
: 6. Integration, differentiation and curve-fit
: 7. Data manipulation and use of auxiliary files
: 8. List of interesting but not demonstrated commands
:
:
:
pause
: -------------------------------------------------------------------
:
: 1. Profile on the IBM-PC (and its video adaptor card)
:
: Profile runs on (among many computers) IBM-PCs or true compatibles with 
: Hercules, CGA, EGA, VGA or AT&T 6300 (Olivetti) graphics adaptors. It 
: automatically senses which adaptor is present, but sometimes makes a mistake.
:
: The command  adapt  is used to ask which card is sensed and to set another
: one if this is wrong. If the wrong card is sensed, edit tutorial.pro and 
: remove one of the five comment colons (: means comment in Profile) below:

: adapt Hercules
: adapt Olivetti/AT&T
: adapt CGA
: adapt EGA
: adapt VGA

: we will now ask Profile what adaptor card it is currently sensing:

adapt ?
pause
: 
: 2. Profile data structures (variables and data types)
:
: Basic data structures of Profile are integer and real variables (scalar)
: and 1D columns of real data (called 'data types'). Most data structures
: must be declared before using with the commands  var  and  type. 
:
: However, some variables and 'data types' (columns) are present by 
: default and need not be declared. Most notable examples are:
:
: -> integer variable ndata, contains current number of data lines
: -> data type count, counts from 0 to ndata-1 (unless changed)
:
: We will now declare some data structures to be used further. Later
: on we will declare some more (this is always possible).

var int  naxis1 naxis2   $
var real ysum   yinte    $
type xaxis1 y1 y2 $

: Declarations end in $ to indicate the end of the argument list

pause
:
: 3. Internal generation of data and making graphs
:
: Profile accepts either commands (such as adapt or type) or 
: mathematical expressions containing variables, data types and constants.
: If an = sign is present, assignment is made. Otherwise the result is
: printed. Some much used constants are present by default, for example

pi

: The default data type count may be used for data generation:

ndata=40
xaxis1=count/(ndata-1)*2*pi
y1=sin(xaxis1)
naxis1=ndata

: The view command is used to look at data. Give  <enter> to leave!

pause
view xaxis1 y1 $

: Columns of data are listed using the  print  command.
: Part of the lines are optionally selected by ending in: | [start] [end] 

pause
print xaxis1 y1 | 12 24 

: Some more data is generated and a graph is made with both y1 and y2

y2=cos(2*xaxis1)

pause
view xaxis1 y1 y2 $

: The view command has more possibilities: a right xaxis may also be 
: used and scaling values can be forced using the default variables:
:
: xls  - X Left  Scale
: xrs  - X Right Scale
: yls  - Y Lower Scale       (left  y axis)
: yus  - Y Upper Scale       (left  y axis)
: ryls - Right Y Lower Scale (right y axis)
: ryus - Right Y Upper Scale (right y axis)
:
: Autoscaling is restored if  xls >= xrs,  etcetera.

xls  = -1.0
xrs  =  8.0
yus  =  1.2
yls  = -1.2
ryus =  2.0
ryls = -2.0

pause
view xaxis1 y1 | y2 $

: Restore the autoscaling by (re)setting scaling variables to zero

xls  = 0
xrs  = 0
yus  = 0
yls  = 0
ryus = 0
ryls = 0

: Log plots can be made by taking the logarithm of the data
: ---------

type log_y1 log_y2 $

: Argument of log() may not become zero!

log_y1 = log(abs(y1)+0.001)
log_y2 = log(abs(y2)+0.001)

pause
view xaxis1 log_y1 log_y2 $

:
: 4. Reading and writing data from and to file
:
: Data can be written to and read from file with the commands  put & get.
:
: -> put [filename] [data type names] $
: -> get [filename] [data type names] $
:
: Data has to be present in the form of legible columns of numbers. A one
: line heading containing the names of the columns is allowed (and made by
: the put command).
:
: If the get command is given without arguments, it automatically uses and
: necessarily declares the appropriate columns ('data types').
: The view command also shows these 'last read' types automatically. A fast
: "get 'n see" sequence thus becomes:
:
: get file.dat $
: view $              (or also print $  and even put [filename] $)
:
: This will be illustrated by putting a file, and getting and viewing it.

pause

put tutor.dat xaxis1 y1 y2 $
get tutor.dat $

pause

: show last read data types
view $

: It is remarked (but not demonstrated) that the commands
:
: startmark [begin of reading marker text]
: endmark   [end   of reading marker text]
:
: are available to select only part of a file for reading.
: Later on, try typing  help startmark  for some explanation.

pause

: 5. Escaping to the operating system (on the PC MS-DOS)
:
: Many operating system commands (such as dir and del, etc) can be typed
: to the Profile prompt ("prof> ", only shown interactively). They are
: executed if a command.com file can be loaded by the system.
:
: If Profile doesn't recognize a command (e.g. because it is not a standard
: MS-DOS command or one of the DOS commands that is also a Profile command
: such as type and print), you can use the 'shell escape' sign %
:
: An example:
:
pause
% type tutor.dat

: Now look at the directory and delete our data file tutor.dat:

dir
del tutor.dat

pause

: Run your application program (e.g. in development) from Profile 
: and use the Profile history mechanism to rapidly see your results:
:
: % myprog mydata.in           : execute the external program MYPROG
: get myprog.out $             : read output (file with header)
: view $                       : look at output
: % edit mydata.in             : change input for myprog with your editor
: % myprog mydata.in           : re-run the external program MYPROG
: !get                         : repeat the last line starting with 'get'
: !vi                          : repeat the last line starting with 'vi'
: .... etc

pause

: 6. Integration, differentiation and curve-fit
:
: Profile offers facilities for numerical data processing. With an example
: integration, differentiation and curve-fit are demonstrated. 
:
: Using a synthetic x-axis, a Gaussian curve is formed. This is integrated
: to give the shape of the error function erf(x). The integral value on a
: sufficiently large interval should equal sqrt(pi). This is verified.

type x2 gauss errorf $
ndata = 100
: reset the count default data type
recount
x2 = 6*((count/(ndata-1))-0.5)
gauss = exp(-x2*x2)
: integrate gaussian function to find error function
inte gauss x2 errorf

: Take a look at the results up till now

xls = -3.5
xrs =  3.5
pause
view x2 gauss errorf $

: Check integral value by assigment of data type errorf to a real variable,
: and divide by the expected value to see the relative error:

var real gaussarea $
gaussarea = errorf
gaussarea
gaussarea / sqrt(pi)

pause

: Curve-fit.
:
: The Profile command  fit  makes a polynomial (recursive) fit to available
: data. This is done by minimizing the sum of squared differences between 
: measured and fit data. The data type  weight  (present by default) may be 
: used to assign different weights to error sum components. By default, 
: weight=1 for all elements. The default integer variable  npoly  may be 
: used to limit the order of the polynomial. 
:
: A polynomial of 6th order is fit to the computed gaussian. A list is 
: printed of the variance (a measure of the fit accuracy) and the ratio
: between subsequent variances. Note that for the even gaussian function,
: addition of odd polynomial orders does not improve the fit!

npoly=6
type fitgauss $

pause
fit gauss x2 fitgauss

: The fit command does not end in '$' because the number of 
: arguments is known in advance. Let's take a look at the results:

pause
view x2 gauss fitgauss $

: A better fit can be obtained by setting npoly=12 (the highest allowed). 
: Maybe you can try this your self at the end of this tutorial.
:
: Note that the fit command supplies the first and second derivatives
: of the fitted polynomial in the default data types tmp1 and tmp2. 
: 
: The same method of differentiation can be invoked by using the 
: diff  command like:
:
: -> diff fit gauss x2 dgaussdx
:
: Here we will demonstrate differentiation by simple differencing
: (subtraction of values). This is useful only if your data is very 
: smooth. The differentiation of errorf (integrated from gauss)
: should return our gaussian function:

type derf_dx2 $
diff num errorf x2 derf_dx2 
compare derf_dx2 gauss

pause
: The compare command shows only a small difference. Look at the graphs:

pause
view x2 gauss derf_dx2 $

: 7. Data manipulation and use of auxiliary files
:
: Finally, we will show some small Profile 'tricks' to bring data in
: a desired form. With some creativity, many things can be arranged
: using:
:
: - the pos(), pls() and neg() functions to select parts of a data type
:   this is demonstrated in example2.pro
: - the assign and extract commands to access individual data elements
: - the map command to interpolate data from one x-axis to another
: - the reduce and remove commands to throw away data lines
: - the insert command to add new (zeroed) data lines
: - the sort command to sort all lines according to one data type
: - intermediate files to temporarily store data
:
: Not everything can be demonstrated here. One small example:
:
pause
:
: The gaussian will be put in front of the error function to form one
: long data column. The x2 x-axis is also duplicated.
: 
: First save the gaussian in a temporary file.

put gauss.tmp x2 gauss $

: Create the prolonged x-axis by copy and addition.

var real xmin xmin2 xmax $

extract x2 1     xmin 
extract x2 2     xmin2
extract x2 ndata xmax

x2 = x2 + (xmax-xmin) + (xmin2-xmin) 

pause

: Insert enough lines to contain the first x-axis and the gauss.
: Put the error function 'on top'.
: Read the gauss and put it in front of the error function.

insert 1 ndata
gauss = errorf
get gauss.tmp x2 gauss $
del gauss.tmp
ndata = ndata*2

: look at the result!

pause

: disable forced x-axis scaling
xls=0
xrs=0
view x2 gauss $

: 
: ------------------------------------------------------------------
:
: This completes the Profile tutorial introduction.
:
: Many things were not treated. The most important omission is the 
: Profile command  levmar  that does non-linear parameter extraction
: by the Levenberg-Marquardt method on parametrized data models.
:
: Example1.pro gives a demonstration of the levmar command.
:
: Please continue playing a little with Profile and use
:
: - help <command> for help on a specific command
: - help help      for a list of all help pages
: - show           for a list of variables and data types in use
: - history or h   for a list of recently given commands (to be repeated)
:
: Note that Profile runs on UNIX and VAX/VMS computers as well. Give
: help public  to read Copyright information and find the address to
: apply for a licence agreement to obtain the source code (in C).
:
: Give <quit enter> to leave Profile.
:
